#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//brickmodMod01.fsh   by Del 
//https://www.shadertoy.com/view/ssBGRR
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// brickmod
//#define SYMMETRIC

vec4 BrickGridMod(vec2 uv, out vec2 id,float aspect)
{
    vec2 pos = uv * vec2(1.0,aspect);
    pos.x += floor(uv.y*aspect)/aspect;
    id = floor(pos);
    id.y /= aspect;
    pos = fract(pos);
    vec2 uv2 = fract (pos)-0.5;
    uv2.y /= aspect;
    pos=abs(fract (pos + 0.5) - 0.5);
    float d = min(pos.x,pos.y/aspect);
    return vec4(abs(d),length(uv2),uv2);
}

// IQ's vec2 to float hash.
float hash21(vec2 p){  return fract(sin(dot(p, vec2(27.619, 57.583)))*43758.5453); }

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) {
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{

    float t = 0.0;//iTime;
	vec2 uv = (fragCoord.xy - 0.5 * iResolution.xy) / iResolution.y;
	
    float zoom = 8.0;
    if (iMouse.z>0.5)
        zoom += sin(uv.x*3.0+iTime); // Wibble
	
	vec2 id;
	vec4 h = BrickGridMod(uv*zoom, id, 2.4);
    
    #ifdef SYMMETRIC
    // symmetric
    float patternVal =165.5; // 33.5
    float blend = pow(abs(sin(length(id)*patternVal + t*0.65)), 16.0);	// pulse mult
    #else
    // randomized
    float blend = pow(abs(sin(hash21(id)*4.35 + t*0.65)), 16.0);	// pulse mult
    #endif

	vec3 shapecol1  = vec3(0.4,0.2,0.2);
	vec3 shapecol2  = vec3(0.65,0.55,0.5);
	shapecol1 = mix(shapecol1,shapecol2,blend);
	vec3 finalcol = mix(vec3(0.1),shapecol1,smoothstep(0.0, 0.035, h.x)); 
	//finalcol = mix(vec3(1.0),finalcol,smoothstep(0.0, 0.035, h.y)); 
	fragColor = vec4(finalcol,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

